<?php

class WH_LogicHooks {

    public function afterSave(SugarBean $bean, $event, $arguments) {
        $isNew = empty($bean->fetched_row['id']) || !empty($bean->new_with_id);
        $action = $isNew ? 'create' : 'update';
        $module = $bean->module_name;
        foreach ($this->getWebhooks($module, $action) as $webhook) {
            $data = [
                'module' => $module,
                'action' => $action,
                'data' => $bean->toArray(),
                'data_before' => !$isNew ? array_merge($bean->fetched_row, $bean->fetched_rel_row) : [],
            ];
            $this->triggerWebhook($webhook, $data);
        }
    }

    public function afterDelete(SugarBean $bean, $event, $arguments) {
        $module = $bean->module_name;
        foreach ($this->getWebhooks($module, 'delete') as $webhook) {
            $data = [
                'module' => $module,
                'action' => $action,
                'data' => $bean->toArray(),
            ];
            $this->triggerWebhook($webhook, $data);
        }
    }

    protected function getWebhooks($module, $action) {
        $webhooks = BeanFactory::getBean('WH_WebHooks');
        $query = [
            'wh_webhooks.status' => 'Active',
            'wh_webhooks.trigger_module' => $module,
            'wh_webhooks.trigger_action' => $action,
        ];
        $where = str_replace('WHERE', '', $webhooks->get_where($query, false));
        return $webhooks->get_full_list('', $where);
    }

    protected function triggerWebhook($webhook, $data) {
        $url = $webhook->url;
        if (empty($url)) {
            LoggerManager::getLogger('SugarCRM')->error("{$id} - Webhook {$webhook->id} trigger error: empty url");
            return false;
        }
        $httpReqeustType = $webhook->http_request_type ?? 'POST';
        try {
            $id = uniqid();
            LoggerManager::getLogger('SugarCRM')->info("{$id} - Webhook {$webhook->id} trigger: starting, url: {$url}. data: " . print_R($data, 1));
            if ($httpReqeustType == 'GET') {
                $url .= (strpos($url, '?') === FALSE ? '?' : '&' ) . http_build_query($data);
                $curl = curl_init($url);
            } else {
                $curl = curl_init($url);
                curl_setopt($curl, CURLOPT_POST, true);
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($curl, CURLOPT_HTTPHEADER, ['Content-type: application/json']);
                curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
            }

            curl_setopt($curl, CURLOPT_HEADER, false);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            $response = curl_exec($curl);
            if (!$response) {
                LoggerManager::getLogger('SugarCRM')->error("{$id} - Webhook {$webhook->id} trigger error: No response. url: {$url}.");
                return false;
            }
            LoggerManager::getLogger('SugarCRM')->info("{$id} - Webhook {$webhook->id} trigger: got response, url: {$url}. response: " . print_R($response, 1));
            return $response;
        } catch (Exception $ex) {
            LoggerManager::getLogger('SugarCRM')->error("{$id} - Webhook {$webhook->id} trigger error: url: {$url}. Code: {$ex->getCode()}. Message: {$ex->getMessage()}");
            return false;
        }
    }

}
